class PBMutator_Damage extends Mutator config;

var bool Init;
var GRI GRI;

function PostBeginPlay()
{
	if (Init)
		return;
	Init = True;

	Level.Game.RegisterDamageMutator(Self);
}

/* Damagetypes:
'escaped' - used when balloon escapes the player
'enforcer' - hitdamage = 1
'sniperrifle' - hitdamage = 10
'RazorJack' - hitdamage = 4
'RazorJackAlt' - hitdamage = 6
'Minigun' - hitdamage = 2
'RocketLauncherPri' = 10
'RocketLauncherAlt' = 12
'FlakCannonPri' = 4
'FlakCannonAlt' = 15
'PulseGun' = 3
'GlueGun' = 2
'Glued' = ActualDamage
'ShockRifle' = ActualDamage
'UZI' = 2
'Tower' = ActualDamage
*/

function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
local Inv_GotGlued GG;
local Inv_GotFrozen GF;
local bool bGotGlued, bGotFrozen, bAlreadyBeenTagged;
local Inventory Inv;
local Pawn P;

	//Check if balloon is camo and if player/tower has camo detection:
	if ( Victim.IsA('Balloon') && Balloon(Victim).bCamo )
		{
		if ( InstigatedBy.IsA('PlayerPawn') )
			{
			if ( !PBPRI(PlayerPawn(InstigatedBy).PlayerReplicationInfo).bHasCamoDetection )
				{
				InstigatedBy.ReceiveLocalizedMessage( class'CantShootCamoMessage',,);
				ActualDamage = 0;
				}
			}
		else if ( InstigatedBy.IsA('Tower') )
			{
			P = Tower(InstigatedBy).TowerOwner;
			if ( !PBPRI(PlayerPawn(P).PlayerReplicationInfo).bHasCamoDetection )
				{
				InstigatedBy.ReceiveLocalizedMessage( class'CantShootCamoMessage',,);
				ActualDamage = 0;
				}
			}
		}

	//Null player damage vs other player
	if ( Victim.IsA('PlayerPawn') && InstigatedBy.IsA('PlayerPawn') )
		{
		//Make sure that self inflicted damage gets taken:
		if ( Victim != InstigatedBy )
			{
			InstigatedBy.ReceiveLocalizedMessage( class'CantShootPlayerMessage',,);
			ActualDamage = 0;
			}
		else
			{
			InstigatedBy.ReceiveLocalizedMessage( class'DamageTowardsSelfMessage',,);
			}
		return;
		}
		
	//Check if balloon has escaped:
	if ( Victim.IsA('Balloon') && DamageType == 'escaped' )
		{
		GRI = GRI(DeathMatchPlus(Level.Game).GameReplicationInfo);
		GRI.Lives -= Victim.Health;
		if ( GRI.Lives < 0 )
			GRI.Lives = 0;
		}
	
	//Check if balloon got glued:
	else if ( Victim.IsA('Balloon') && DamageType == 'Glued' )
		{
		InstigatedBy.PlayerReplicationInfo.Score += ActualDamage;
		PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += ActualDamage;
		}
		
	//Check for damage done by tower:
	else if ( Victim.IsA('Balloon') && DamageType == 'Tower' )
		{
		InstigatedBy.PlayerReplicationInfo.Score += ActualDamage;
		PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += ActualDamage;
		}
		
	if ( DamageType != 'escaped' && InstigatedBy.IsA('PlayerPawn') )
		{
		//Uzi:
		if ( DamageType == 'UZI' && Victim.Health > 0 )
			{
			if ( Victim.IsA('Balloon_Metal') )
				{
				InstigatedBy.ReceiveLocalizedMessage( class'CantShootMetalMessage',,);
				ActualDamage = 0;
				}
			else if ( Victim.IsA('Balloon_Clay') )
				{
				InstigatedBy.ReceiveLocalizedMessage( class'CantShootClayMessage',,);
				ActualDamage = 0;
				}
			else if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
				{
				InstigatedBy.PlayerReplicationInfo.Score += 4;
				PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 2;
				}
			else
				{
				InstigatedBy.PlayerReplicationInfo.Score += 2;
				PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 2;
				}
			}
		//Enforcer:
		if ( DamageType == 'enforcer' && Victim.Health > 0 )
			{
			if ( Victim.IsA('Balloon_Metal') )
				{
				InstigatedBy.ReceiveLocalizedMessage( class'CantShootMetalMessage',,);
				ActualDamage = 0;
				}
			else if ( Victim.IsA('Balloon_Clay') )
				{
				InstigatedBy.ReceiveLocalizedMessage( class'CantShootClayMessage',,);
				ActualDamage = 0;
				}
			else if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
				{
				InstigatedBy.PlayerReplicationInfo.Score += 2;
				PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 2;
				}
			else
				{
				InstigatedBy.PlayerReplicationInfo.Score += 1;
				PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 1;
				}
			}
		//Shock Rifle:
		else if ( DamageType == 'ShockRifle' && Victim.Health > 0 )
			{
			if	( Victim.Health - ActualDamage > 0 )
				{
				if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 2 * ActualDamage;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += ActualDamage;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += ActualDamage;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += ActualDamage;
					}
				}
			else
				{
				if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 2 * Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					}
				}
			}
		//Sniper Rifle:
		else if ( DamageType == 'sniperrifle' && Victim.Health > 0 )
			{
			if	( Victim.Health - 10 > 0 )
				{
				if ( Victim.IsA('Balloon_Metal') )
					{
					InstigatedBy.ReceiveLocalizedMessage( class'CantShootMetalMessage',,);
					ActualDamage = 0;
					}
				else if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 20;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 10;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 10;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 10;
					}
				}
			else
				{
				if ( Victim.IsA('Balloon_Metal') )
					{
					InstigatedBy.ReceiveLocalizedMessage( class'CantShootMetalMessage',,);
					ActualDamage = 0;
					}
				else if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 2 * Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					}
				}
			}
		//RazorJack Primary Projectile:
		else if ( DamageType == 'RazorJack' && Victim.Health > 0 )
			{
			if	( Victim.Health - 4 > 0 )
				{
				if ( Victim.IsA('Balloon_Metal') )
					{
					InstigatedBy.ReceiveLocalizedMessage( class'CantShootMetalMessage',,);
					ActualDamage = 0;
					}
				else if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 8;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 4;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 4;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 4;
					}
				}
			else
				{
				if ( Victim.IsA('Balloon_Metal') )
					{
					InstigatedBy.ReceiveLocalizedMessage( class'CantShootMetalMessage',,);
					ActualDamage = 0;
					}
				else if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 2 * Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					}
				}
			}
		//RazorJack Alt Projectile:
		else if ( DamageType == 'RazorJackAlt' && Victim.Health > 0 )
			{
			if	( Victim.Health - 6 > 0 )
				{
				if ( Victim.IsA('Balloon_Metal') )
					{
					InstigatedBy.ReceiveLocalizedMessage( class'CantShootMetalMessage',,);
					ActualDamage = 0;
					}
				else if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 12;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 6;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 6;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 6;
					}
				}
			else
				{
				if ( Victim.IsA('Balloon_Metal') )
					{
					InstigatedBy.ReceiveLocalizedMessage( class'CantShootMetalMessage',,);
					ActualDamage = 0;
					}
				else if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 2 * Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					}
				}
			}
		//Minigun:
		if ( DamageType == 'Minigun' && Victim.Health > 0 )
			{
			if ( Victim.IsA('Balloon_Metal') )
				{
				InstigatedBy.ReceiveLocalizedMessage( class'CantShootMetalMessage',,);
				ActualDamage = 0;
				}
			else if ( Victim.IsA('Balloon_Clay') )
				{
				InstigatedBy.ReceiveLocalizedMessage( class'CantShootClayMessage',,);
				ActualDamage = 0;
				}
			else if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
				{
				InstigatedBy.PlayerReplicationInfo.Score += 2;
				PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 2;
				}
			else
				{
				InstigatedBy.PlayerReplicationInfo.Score += 1;
				PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 1;
				}
			}
		//Rocket Launcher Primary fire:
		else if ( DamageType == 'RocketLauncherPri' && Victim.Health > 0 )
			{
			if	( Victim.Health - 10 > 0 )
				{
				if ( Victim.IsA('Balloon_Liquid') )
					{
					InstigatedBy.ReceiveLocalizedMessage( class'CantShootLiquidMessage',,);
					ActualDamage = 0;
					}
				else if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 20;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 10;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 10;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 10;
					}
				}
			else
				{
				if ( Victim.IsA('Balloon_Liquid') )
					{
					InstigatedBy.ReceiveLocalizedMessage( class'CantShootLiquidMessage',,);
					ActualDamage = 0;
					}
				else if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 2 * Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					}
				}
			}
		//Rocket Launcher Alt fire:
		else if ( DamageType == 'RocketLauncherAlt' && Victim.Health > 0 )
			{
			if	( Victim.Health - 12 > 0 )
				{
				if ( Victim.IsA('Balloon_Liquid') )
					{
					InstigatedBy.ReceiveLocalizedMessage( class'CantShootLiquidMessage',,);
					ActualDamage = 0;
					}
				else if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 24;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 12;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 12;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 12;
					}
				}
			else
				{
				if ( Victim.IsA('Balloon_Liquid') )
					{
					InstigatedBy.ReceiveLocalizedMessage( class'CantShootLiquidMessage',,);
					ActualDamage = 0;
					}
				else if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 2 * Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					}
				}
			}
		//Flak Cannon Primary fire:
		else if ( DamageType == 'FlakCannonPri' && Victim.Health - 4 > 0 )
			{
			if	( Victim.Health - 4 > 0 )
				{
				if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 8;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 4;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 4;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 4;
					}
				}
			else
				{
				if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 2 * Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					}
				}
			}
		//Flak Cannon Alt fire:
		else if ( DamageType == 'FlakCannonAlt' && Victim.Health - 15 > 0 )
			{
			if	( Victim.Health - 15 > 0 )
				{
				if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 30;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 15;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 15;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 15;
					}
				}
			else
				{
				if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 2 * Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					}
				}
			}
		//Pulsegun:
		if ( DamageType == 'PulseGun' && Victim.Health - 3 > 0 )
			{
			if ( Victim.IsA('Balloon_Metal') )
				{
				InstigatedBy.ReceiveLocalizedMessage( class'CantShootMetalMessage',,);
				ActualDamage = 0;
				}
			else if ( Victim.IsA('Balloon_Clay') )
				{
				InstigatedBy.ReceiveLocalizedMessage( class'CantShootClayMessage',,);
				ActualDamage = 0;
				}
			else if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
				{
				InstigatedBy.PlayerReplicationInfo.Score += 6;
				PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 3;
				}
			else
				{
				InstigatedBy.PlayerReplicationInfo.Score += 3;
				PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 3;
				}
			}
		else if ( DamageType == 'PulseGun' && Victim.Health > 0 )
			{
			if ( Victim.IsA('Balloon_Metal') )
				{
				InstigatedBy.ReceiveLocalizedMessage( class'CantShootMetalMessage',,);
				ActualDamage = 0;
				}
			else if ( Victim.IsA('Balloon_Clay') )
				{
				InstigatedBy.ReceiveLocalizedMessage( class'CantShootClayMessage',,);
				ActualDamage = 0;
				}
			else if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
				{
				PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 2 * Victim.Health;
				PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
				}
			else
				{
				PBPRI(InstigatedBy.PlayerReplicationInfo).Score += Victim.Health;
				PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
				}
			}
		//Glue Gun:
		else if ( DamageType == 'GlueGun' && Victim.Health > 0 )
			{
			if	( Victim.Health - 2 > 0 )
				{
				if ( Victim.IsA('Balloon_Liquid') )
					{
					InstigatedBy.ReceiveLocalizedMessage( class'CantShootLiquidMessage',,);
					ActualDamage = 0;
					}
				else if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 4;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 2;
					bGotGlued = True;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 2;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 2;
					bGotGlued = True;
					}
				}
			else
				{
				if ( Victim.IsA('Balloon_Liquid') )
					{
					InstigatedBy.ReceiveLocalizedMessage( class'CantShootLiquidMessage',,);
					ActualDamage = 0;
					}
				else if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 2 * Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					bGotGlued = True;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					bGotGlued = True;
					}
				}
			}
		//Cold Breeze:
		else if ( DamageType == 'ColdBreeze' && Victim.Health > 0 )
			{
			if	( Victim.Health - 2 > 0 )
				{
				if ( Victim.IsA('Balloon_zeppelin') )
					{
					InstigatedBy.ReceiveLocalizedMessage( class'CantFreezeZeppelinMessage',,);
					ActualDamage = 0;
					}
				else if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 4;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 2;
					bGotFrozen = True;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 2;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += 2;
					bGotFrozen = True;
					}
				}
			else
				{
				if ( Victim.IsA('Balloon_zeppelin') )
					{
					InstigatedBy.ReceiveLocalizedMessage( class'CantFreezeZeppelinMessage',,);
					ActualDamage = 0;
					}
				else if (PBPRI(InstigatedBy.PlayerReplicationInfo).DoubleCashTime > 0)
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += 2 * Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					bGotFrozen = True;
					}
				else
					{
					PBPRI(InstigatedBy.PlayerReplicationInfo).Score += Victim.Health;
					PBPRI(InstigatedBy.PlayerReplicationInfo).RankScore += Victim.Health;
					bGotFrozen = True;
					}
				}
			}
		//Next weapon:
		}
	
	if ( bGotGlued && Balloon(Victim).bCanBeGlued )
		{
		for ( Inv=Victim.inventory; Inv!=None; Inv=Inv.inventory )
			if ( Inv.IsA('Inv_GotFrozen') || Inv.IsA('Inv_GotGlued') )
				{
				bAlreadyBeenTagged = True;
				}
		if ( !bAlreadyBeenTagged )
			{
			GG  = Spawn(Class'Inv_GotGlued', Victim, 'Inv_GotGlued' , Victim.location, Victim.Rotation);
			if ( GG != None )
				{
				GG.BecomePickup();
				GG.bHeldItem = True;
				GG.RespawnTime = 0.0;
				GG.GiveTo(Victim);
				GG.InstigatedBy = InstigatedBy;
				GG.GlueLevel = PBPRI(PlayerPawn(InstigatedBy).PlayerReplicationInfo).GlueLevel;
				GG.Activate();
				}
			}
		}

		
	if ( bGotFrozen && Balloon(Victim).bCanBeFrozen )
		{
		for ( Inv=Victim.inventory; Inv!=None; Inv=Inv.inventory )
			if ( Inv.IsA('Inv_GotFrozen') || Inv.IsA('Inv_GotGlued') )
				{
				bAlreadyBeenTagged = True;
				}
		if ( !bAlreadyBeenTagged )
			{
			GF  = Spawn(Class'Inv_GotFrozen', Victim, 'Inv_GotFrozen' , Victim.location, Victim.Rotation);
			if ( GF != None )
				{
				GF.BecomePickup();
				GF.bHeldItem = True;
				GF.RespawnTime = 0.0;
				GF.GiveTo(Victim);
				GF.InstigatedBy = InstigatedBy;
				//GF.FrozenLevel = PBPRI(PlayerPawn(InstigatedBy).PlayerReplicationInfo).FrozenLevel;
				GF.Activate();
				}
			}
		}

	
	if ( NextDamageMutator != None )
     		NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
}

defaultproperties
{
}
